/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.TriggerParameter;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo0;

public class LinkerToLogo0Long
extends LinkerToLogo0 {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;

    public LinkerToLogo0Long(Hardware hw) {
        super(hw);
    }

    public Object visit(CounterParameter param) {
        int[] eeprom = new int[3];
        int limes = param.getLimValue();
        eeprom[0] = param.getProtection() ? 240 : 241;
        eeprom[1] = (limes & 0x7F00) >> 8;
        eeprom[2] = limes & 0xFF;
        this.setReference(this.putParameter(eeprom));
        int msbLowWord = (limes & 0x8000) >> 15;
        eeprom = new int[3];
        eeprom[0] = 240;
        eeprom[1] = this.getFreeRAMorREMCounter(param);
        this.getFreeRAMorREMCounter(param);
        eeprom[2] = (limes & 0xFF0000) >> 15 | msbLowWord;
        this.putParameter(eeprom);
        return null;
    }

    public Object visit(HoursCounterParameter param) {
        int[] eeprom = new int[3];
        int maintanceInterval = param.getMI_Minute() / 60;
        eeprom[0] = param.getProtection() ? 240 : 241;
        eeprom[1] = (maintanceInterval & 0xFF00) >> 8;
        eeprom[2] = maintanceInterval & 0xFF;
        this.setReference(this.putParameter(eeprom));
        eeprom = new int[3];
        eeprom[0] = 240;
        eeprom[1] = this.getFreeREM();
        this.getFreeREM();
        eeprom[2] = this.getFreeREM();
        this.getFreeREM();
        this.putParameter(eeprom);
        return null;
    }

    public Object visit(TriggerParameter param) {
        int[] eeprom = new int[3];
        int temp = param.getOnThreshold().getCurrentValue();
        eeprom[0] = param.getProtection() ? 240 : 241;
        eeprom[1] = (temp & 0xFF00) >> 8;
        eeprom[2] = temp & 0xFF;
        this.setReference(this.putParameter(eeprom));
        eeprom = new int[3];
        temp = param.getOffThreshold().getCurrentValue();
        eeprom[0] = 240;
        eeprom[1] = (temp & 0xFF00) >> 8;
        eeprom[2] = temp & 0xFF;
        this.putParameter(eeprom);
        int[] time = param.getTimeInterval().getParamTime().getLogoTime();
        eeprom = new int[]{240, time[0], time[1]};
        this.putParameter(eeprom);
        this.setReference(this.getFreeTimer());
        this.setReference(this.getFreeRAMorREM(param));
        this.getFreeRAMorREM(param);
        this.getFreeRAMorREM(param);
        return null;
    }
}

